//Aim:To design m-derived T and pi section low-pass filter.
//Software version Scilab 5.5.2
//OS Windows 7

clear;
clc;
fc=1800;//fc is the cutoff frequency
f_infinity=2000;//f_infinity is the infinite attenuation frequency
R0=600;//R0 is the nominal characteristic impedence

//Computing the value of m:
m=sqrt(1-((fc/f_infinity)^2));
disp(m,'m=')
L=R0/(%pi*fc);//L is the series arm inductance
disp('H',L,'L=')
C=1/(%pi*R0*fc);//C is the shunt arm capacitance
disp('F',C,'C=')

//Computation of values of the elements for the T section 
//of the m-derived filter:
a=(m*L/2);
disp('H',a,'mL/2=')
b=m*C;
disp('F',b,'mC=')
c=((1-(m^2))/(4*m))*L;
disp('H',c,'((1-(m^2))/(4*m)))*L=')

//Computation of the values of the elements for the pi-section 
//of the m-derived filter :
d=(m*C)/2;
disp('F',d,'mC/2=')
e=m*L;
disp('H',e,'mL=')
f=((1-(m^2))/(4*m))*C;
disp('F',f,'((1-(m^2))/(4*m))*C=')

